import { View, Text, StyleSheet, Pressable } from "react-native";
import NoInternetIcon from '../../assets/icons/no-wifi.svg';
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import useLangTranslation from "../../hooks/useLangTranslation";

const NoInternet = () => {
    const { trans } = useLangTranslation();

    const onPress = () => {};
    return (
        <View style={styles.container}>
            <NoInternetIcon/>
            <Text style={styles.title}>{trans("No Internet Connection")}</Text>
            <Text style={styles.description}>{trans("You have gone offline. Make sure Wi-Fi or cellular data is on and try again.")}</Text>
            <Pressable style={styles.button} onPress={onPress}>
                <Text style={styles.buttonText}>{trans("Try Again")}</Text>
            </Pressable>
        </View>
    );
};

export default NoInternet;

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        paddingVertical: dpr(20),
        alignItems: "center",
        justifyContent: "center",
    },
    title: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(22),
        color: "#2C2C2C",
        lineHeight: dpr(29),
        marginBottom: dpr(12),
    },
    description: {
        textAlign: "center",
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(15),
        color: "#898989",
    },
    button: {
        marginTop: dpr(35),
        backgroundColor: "#FCCA19",
        borderRadius: dpr(6),
        paddingVertical: dpr(14),
        paddingHorizontal: dpr(40),
    },
    buttonText: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
        lineHeight: dpr(22),
    }
});
